-- Update the Guard Condition entity
update entities set instantiable='Y',externalize='Y',allow_tag='Y' where name='Guard Condition'

-- Update the Operation entity tag
update entities set tag='operation' where name='Operation'

-- Change the Hash table format composition rule for Format Element to 0..N
update entities_entities set modifier='*' where ent_parent=(select code from entities where name='Hash table format') and ent_component=(select code from entities where name='Format element')

--Add to the Hash table format composition the following rule: ObjectFormat 0..N
insert into entities_entities values ('11111','0983cbd9e045ca9a26e99fe',null,'0983cbd9e045ca9c9353877',null,'*')

--Modifiy the entity 'Object format'adding the superentity 'Format element'
update entities set SUPER_ENTITY=(select code from entities where name='Field format') where name='Object format'

--Change composition field for 'Transition'
update entities set composite='Y' where name='Transition'

--Change the 'operationName' attribute to REFERENCE datatype, pointing to the 'id' of an 'Operation'
update attributes set datatype='REFERENCE',entity_ref=(select code from entities where name='Operation'),attribute_ref=(select code from attributes where name='id' and entity=(select code from entities where name='Operation')) where name='operationName' and entity=(select code from entities where name='ExecuteOperationAction')

--Capitalize the tag of the 'Converter' and 'Validator'
update entities set tag='Converter' where tag='converter'
update entities set tag='Validator' where tag='validator'

--Add 'operation' in the HTML State types domain
INSERT INTO ALLOWED_VALUES VALUES('0983cbb4e28ba158b48884d','operation','operation','004')

--Add 'value' attribute to the Data reference entity
INSERT INTO ATTRIBUTES VALUES ('0983cb4ee78291bd7672944','0983cbd9e045cb7202a6da9','value','java.lang.String',null,'Value','N',null,null,null,null,'Y')

--Add 'skipValidation' attribute to the HTML Transition entity
INSERT INTO ATTRIBUTES VALUES ('0983cb4ee7829595a726bba','0983cbb4e28bb17d5d4a43e','skipValidation','DOMAIN',null,'Skip validation','N',null,null,null,'094712cadfe7561a15abc21','Y')

--Adding the contents of the 'DSE.Event Manager.Client' group

--Insert the instances

INSERT INTO INSTANCES VALUES('0983cabbe09d71d10266bb8','EventManagerCSFormat','fmtDef',null,null,'4.0f','0983cbd9e045caaa94536e5',null,'000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:16.29','Y','Y','format','EventManagerCSFormat','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d1fdc16f4','record','record',null,null,'4.0f','0983cbd9e045ca927c427a9','0983cabbe09d71d10266bb8','000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:16.541','Y','Y','format','EventManagerCSFormat.record','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d36fdbb9a','operationType','fString',null,null,'4.0f','0983cbd9e045caac9d69ad8','0983cabbe09d71d1fdc16f4','000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:16.911','Y','Y','format','EventManagerCSFormat.record.operationType','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d442854bb','delim','delim',null,null,'4.0f','0983cbd9e045cab484b8749','0983cabbe09d71d1fdc16f4','001','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:17.122','Y','Y','format','EventManagerCSFormat.record.delim','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d5144916b','eventList','iCollF',null,null,'4.0f','0983cbd9e045ca98323ef59','0983cabbe09d71d1fdc16f4','002','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:17.332','Y','Y','format','EventManagerCSFormat.record.eventList','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d5f0bb27a','eventPair','refFmt',null,null,'4.0f','0983cbd9e045cab159c5c78','0983cabbe09d71d5144916b','000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:17.552','Y','Y','format','EventManagerCSFormat.record.eventList.eventPair','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d6b93e2d9','eventPair','fmtDef',null,null,'4.0f','0983cbd9e045caaa94536e5',null,'000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:17.753','Y','Y','format','eventPair','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d6e14592f','eventPair','record',null,null,'4.0f','0983cbd9e045ca927c427a9','0983cabbe09d71d6b93e2d9','000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:17.793','Y','Y','format','eventPair.eventPair','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d78b3c4ea','eventName','fString',null,null,'4.0f','0983cbd9e045caac9d69ad8','0983cabbe09d71d6e14592f','000','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:17.963','Y','Y','format','eventPair.eventPair.eventName','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d85d15c65','delim','delim',null,null,'4.0f','0983cbd9e045cab484b8749','0983cabbe09d71d6e14592f','001','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:18.173','Y','Y','format','eventPair.eventPair.delim','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71d92f7c4c7','notifierName','fString',null,null,'4.0f','0983cbd9e045caac9d69ad8','0983cabbe09d71d6e14592f','002','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:18.383','Y','Y','format','eventPair.eventPair.notifierName','N')
INSERT INTO INSTANCES VALUES('0983cabbe09d71da3e96626','delim#1','delim',null,null,'4.0f','0983cbd9e045cab484b8749','0983cabbe09d71d6e14592f','003','0983ccb4dfdd9994918c6ec','N','2000-07-27 18:09:18.654','Y','Y','format','eventPair.eventPair.delim#1','N')


--Insert the properties
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d442ce4f3','operationType','0983cabbe09d71d36fdbb9a','0983cbd9e045ca6e2ecd66e')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d51499e1b','+','0983cabbe09d71d442854bb','0983cbd9e045cab4c0932b7')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d6ae53146','eventPair','0983cabbe09d71d5f0bb27a','0983cbd9e045cab1b31fc24')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d5dcd37e7','eventList','0983cabbe09d71d5144916b','0983cbd9e045ca986ed3ec3')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d1e9c66fe','EventManagerCSFormat','0983cabbe09d71d10266bb8','0983cbd9e045caab177d769')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d8536ca19','eventName','0983cabbe09d71d78b3c4ea','0983cbd9e045ca6e2ecd66e')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d92513111','+','0983cabbe09d71d85d15c65','0983cbd9e045cab4c0932b7')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d9f8b7fde','notifierName','0983cabbe09d71d92f7c4c7','0983cbd9e045ca6e2ecd66e')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71db92726e4','+','0983cabbe09d71da3e96626','0983cbd9e045cab4c0932b7')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d7818a3ac','eventPair','0983cabbe09d71d6e14592f','0983cbd9e045caae60322c1')
INSERT INTO PROPERTIES VALUES('0983cabbe09d71d6d7973de','eventPair','0983cabbe09d71d6b93e2d9','0983cbd9e045caab177d769')

--Insert into Group instances
INSERT INTO GROUPS_INSTANCES VALUES ('0983cabbe09d8a93f239e1e','0983cabbe09d71d10266bb8')
INSERT INTO GROUPS_INSTANCES VALUES ('0983cabbe09d8a93f239e1e','0983cabbe09d71d6b93e2d9')







--Create the Executable entity

--insert into entities

INSERT INTO ENTITIES VALUES ('0983cffce4cb708536ae8df','Executable','4.0f','operation','N',null,null,null,null,'N','N','N',null,null,'0983ccb4dfdd9994918c6ec',null,'Y','2001-02-20 11:41:32.47','Y','N','N')

--insert into attributes

INSERT INTO ATTRIBUTES VALUES ('0983cffce4cb70d3a516297','0983cffce4cb708536ae8df','id','java.lang.String',null,'Identifier','Y',null,null,null,null,'Y')
INSERT INTO ATTRIBUTES VALUES ('0983cffce4cb73351355fdf','0983cffce4cb708536ae8df','context','REFERENCE',null,'Context','Y','0983cbd9e044f6e70ff8189','0983cbd9e044f6ef0069235',null,null,'Y')
INSERT INTO ATTRIBUTES VALUES ('0983cffce4cb72b7453e578','0983cffce4cb708536ae8df','implClass','java.lang.String',null,'Implementor class','N',null,null,null,null,'Y')

--insert into groups_entities

INSERT INTO GROUPS_ENTITIES VALUES ('0983cbd9e045c8d42dff18d','0983cffce4cb708536ae8df')


--Updates for the Operation

UPDATE ENTITIES SET SUPER_ENTITY='0983cffce4cb708536ae8df' where name='Operation'


UPDATE PROPERTIES SET ATTRIBUTE='0983cffce4cb70d3a516297' where attribute=(select code from attributes where name='id' and entity=(select code from entities where name='Operation'))
UPDATE PROPERTIES SET ATTRIBUTE='0983cffce4cb73351355fdf' where attribute=(select code from attributes where name='operationContext' and entity=(select code from entities where name='Operation'))
UPDATE PROPERTIES SET ATTRIBUTE='0983cffce4cb72b7453e578' where attribute=(select code from attributes where name='implClass' and entity=(select code from entities where name='Operation'))


UPDATE ATTRIBUTES SET ATTRIBUTE_REF='0983cffce4cb70d3a516297' where attribute_ref=(select code from attributes where name='id' and entity=(select code from entities where name='Operation'))
UPDATE ATTRIBUTES SET ATTRIBUTE_REF='0983cffce4cb73351355fdf' where attribute_ref=(select code from attributes where name='operationContext' and entity=(select code from entities where name='Operation'))
UPDATE ATTRIBUTES SET ATTRIBUTE_REF='0983cffce4cb72b7453e578' where attribute_ref=(select code from attributes where name='implClass' and entity=(select code from entities where name='Operation'))

UPDATE ATTRIBUTES SET ENTITY_REF='0983cffce4cb708536ae8df' where entity_ref=(select code from entities where name='Operation')
UPDATE ATTRIBUTES SET ENTITY_REF='0983cffce4cb708536ae8df' where entity_ref=(select code from entities where name='Operation')
UPDATE ATTRIBUTES SET ENTITY_REF='0983cffce4cb708536ae8df' where entity_ref=(select code from entities where name='Operation')

DELETE FROM ATTRIBUTES WHERE NAME='id' and ENTITY=(select code from entities where name='Operation')
DELETE FROM ATTRIBUTES WHERE NAME='implClass' and ENTITY=(select code from entities where name='Operation')
DELETE FROM ATTRIBUTES WHERE NAME='operationContext' and ENTITY=(select code from entities where name='Operation')



--Updates for the Processor

UPDATE ENTITIES SET SUPER_ENTITY='0983cffce4cb708536ae8df' where name='Processor'


UPDATE PROPERTIES SET ATTRIBUTE='0983cffce4cb70d3a516297' where attribute=(select code from attributes where name='id' and entity=(select code from entities where name='Processor'))
UPDATE PROPERTIES SET ATTRIBUTE='0983cffce4cb73351355fdf' where attribute=(select code from attributes where name='operationContext' and entity=(select code from entities where name='Processor'))
UPDATE PROPERTIES SET ATTRIBUTE='0983cffce4cb72b7453e578' where attribute=(select code from attributes where name='implClass' and entity=(select code from entities where name='Processor'))


UPDATE ATTRIBUTES SET ATTRIBUTE_REF='0983cffce4cb70d3a516297' where attribute_ref=(select code from attributes where name='id' and entity=(select code from entities where name='Processor'))
UPDATE ATTRIBUTES SET ATTRIBUTE_REF='0983cffce4cb73351355fdf' where attribute_ref=(select code from attributes where name='operationContext' and entity=(select code from entities where name='Processor'))
UPDATE ATTRIBUTES SET ATTRIBUTE_REF='0983cffce4cb72b7453e578' where attribute_ref=(select code from attributes where name='implClass' and entity=(select code from entities where name='Processor'))

UPDATE ATTRIBUTES SET ENTITY_REF='0983cffce4cb708536ae8df' where entity_ref=(select code from entities where name='Processor')
UPDATE ATTRIBUTES SET ENTITY_REF='0983cffce4cb708536ae8df' where entity_ref=(select code from entities where name='Processor')
UPDATE ATTRIBUTES SET ENTITY_REF='0983cffce4cb708536ae8df' where entity_ref=(select code from entities where name='Processor')

DELETE FROM ATTRIBUTES WHERE NAME='id' and ENTITY=(select code from entities where name='Processor')
DELETE FROM ATTRIBUTES WHERE NAME='implClass' and ENTITY=(select code from entities where name='Processor')
DELETE FROM ATTRIBUTES WHERE NAME='operationContext' and ENTITY=(select code from entities where name='Processor')


--UPDATE THE VERSION NUMBER

UPDATE entities SET versioned='Y',version='4.0f',predefined='Y'
UPDATE groups SET versioned='Y',version='4.0f'
UPDATE instances SET versioned='Y',version='4.0f'
